<?php
Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/admin/main.js');
?>

<style type="text/css">
	#generateNip, #generateRegon, #generateCardNumber {
		vertical-align: middle;
		height: 20px;
		margin-bottom: 5px;
		cursor: pointer;
	}
</style>

<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'kontrahent-form',
	'enableAjaxValidation'=>false,
)); ?>

	<div class="row">
		<?php echo $form->labelEx($model,'nazwa'); ?>
		<?php echo $form->textField($model,'nazwa',array('size'=>60,'maxlength'=>64)); ?>
		<?php echo $form->error($model,'nazwa'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'idDziedziny'); ?>
		<?php echo $form->dropDownList($model,'idDziedziny',array(''=>'brak')+Dziedzina::listAll()); ?>
		<?php echo $form->error($model,'idDziedziny'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'urlLoga'); ?>
		<?php echo $form->textField($model,'urlLoga',array('size'=>60,'maxlength'=>512)); ?>
		<?php echo $form->error($model,'urlLoga'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'NIP'); ?>
		<?php echo $form->textField($model,'NIP',array('size'=>60,'maxlength'=>512)); ?>
		<img title="Generuj" alt="Generuj" id="generateNip" src="<?php echo Yii::app()->baseUrl; ?>/images/gui/button_wizard.png" />
		<?php echo $form->error($model,'NIP'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'REGON'); ?>
		<?php echo $form->textField($model,'REGON',array('size'=>60,'maxlength'=>512)); ?>
		<img title="Generuj" alt="Generuj" id="generateRegon" src="<?php echo Yii::app()->baseUrl; ?>/images/gui/button_wizard.png" />
		<?php echo $form->error($model,'REGON'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'adres'); ?>
		<?php echo $form->textArea($model,'adres',array('size'=>18,'maxlength'=>1000)); ?>
		<?php echo $form->error($model,'adres'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'nrKonta'); ?>
		<?php echo $form->textField($model,'nrKonta',array('size'=>60,'maxlength'=>512)); ?>
		<img title="Generuj" alt="Generuj" id="generateCardNumber" src="<?php echo Yii::app()->baseUrl; ?>/images/gui/button_wizard.png" />
		<?php echo $form->error($model,'nrKonta'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'idBudynku'); ?>
		<?php echo $form->dropDownList($model,'idBudynku',array(''=>'brak')+CHtml::listData($budynki, 'id', 'nazwa')); ?>
		<?php echo $form->error($model,'idBudynku'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'typ'); ?>
		<?php echo $form->dropDownList($model,'typ',Kontrahent::getTypeStrArr()); ?>
		<?php echo $form->error($model,'typ'); ?>
	</div>

	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Utwórz' : 'Zapisz',array('class'=>'buttonS bLightBlue')); ?>
	</div>

<?php $this->endWidget(); ?>

</div>

<script type="text/javascript">
function generateCreditCardNumber()
{
	return '78 1240 5497 1111 0000 ' + generateChecksummedValue([1, 1, 1]) + ' '
					+ generateChecksummedValue([1, 1, 1]);
}

(function()
{
	$('#generateNip').click(function(){
		$('#Kontrahent_NIP').val(generateNip());
	});
	$('#generateRegon').click(function(){
		$('#Kontrahent_REGON').val(generateRegon9());
	});
	$('#generateCardNumber').click(function(){
		$('#Kontrahent_nrKonta').val(generateCreditCardNumber());
	});
})();
</script>